// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

/// <summary>
/// Klasse ist für die Autoauwahl zuständig
/// Sorgt dafür, dass immer nur ein Autoobjekt gleichzeitig aktiv ist
/// </summary>
public class CarSelector : MonoBehaviour {

	/// <summary>
	/// Tag, mit dem alle Autos gefunden werden können
	/// </summary>
	public string carTagName = "Car";

	// Game Objekt, dass das Beschriftungsfeld des Autos im UI darstellt
	public Text carLabel;

	// Image Komponente, wo Autobild angezeigt werden soll
	public Image carImage;
	
	// Auflistung aller Autos die zur Auswahl stehen
	private GameObject[] cars;

	// Index zum Durchzählen des Autoarrays
	private int index;

	// aktuell ausgewähltes Auto
	private GameObject activeCar;

	// Use this for initialization
	void Start () {
		cars = GameObject.FindGameObjectsWithTag (carTagName);
		foreach (var o in cars) {
			o.SetActive(false);
		}
		SetActiveCar (cars [0]);
	}

	/// <summary>
	/// Liefert setzt das nächste Auto als aktiv
	/// </summary>
	public void NextCar() {
		cars [index].SetActive (false);
		// Finde Index für nächstes Arrayelement
		index++;
		if (index >= cars.Length) {
			index = 0;
		}
		SetActiveCar (cars [index]);
	}

	/// <summary>
	/// Liefert setzt das letzte Auto als aktiv
	/// </summary>
	public void LastCar() {
		cars [index].SetActive (false);
		// Finde Index für nächstes Arrayelement
		index--;
		if (index < 0) {
			index = cars.Length - 1;
		}
		SetActiveCar (cars [index]);
	}

	// Setzt neues GameObjekt als aktives Auto
	private void SetActiveCar(GameObject o) {
		o.SetActive (true);
		activeCar = o;
		CarInfo cInfo = activeCar.GetComponent<CarInfo> ();
		// Aktualisiere Autodaten
		carLabel.text = cInfo.carName;
		carLabel.text += "\n" + cInfo.autoBrand;
		carImage.sprite = cInfo.carSprite;
	}

}
