// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Choose car_ confirm action.
/// </summary>
public class ChooseCar_ConfirmAction : MonoBehaviour {

	// Regelt den Übergang zur nächsten Scene
	public MenueStateController menueStateController;

	// Liefert Informationen über das InputField, das den Namen des Spielers enthält
	public InputFieldHandler playerNameInputFieldHandler;

	// Aktion, die Ausgeführt wird wenn Benutzer in der Autoauswahl auf Bestätigen drückt
	public void ConfirmCar() {
		string playerName = playerNameInputFieldHandler.GetValue ();
		// Falls Spielername nicht leer
		if (!playerName.Equals ("")) {
			ScoreManager scoreManager = gameObject.AddComponent<ScoreManager> ();
			scoreManager.SetCurName (playerName);
			menueStateController.setNextScene ("Ingame1");
		} else {
			// Falls InputField leer, setze Focus auf es um Spieler darauf hinzuweisen
			playerNameInputFieldHandler.inputField.Select();
		}
	}

	// Wird jeden Frame ausgeführt
	void Update() {
		// Falls Spieler mit Tastatur bestätigt
		if (Input.GetButton ("Submit") && Input.anyKeyDown) {
			ConfirmCar();
		}
	}

}
