﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

/// <summary>
/// Steuert ein InputField - Speichert immer den dessen aktuellen Inhalt und
/// färbt eine benutzerdefiniertes Image andersfarbig, falls das InputField leer ist
/// </summary>
public class InputFieldHandler : MonoBehaviour {

	// Die "Image" Komponente, die im Fehlerfall (Kein Inhalt) eingefärbt wird
	public Image image;

	// Farbe, in der Image Komponente bei leerem Namensfeld eingefärbt wird
	public Color errorColor;

	// Referenz auf das Eingabefeld, das überprüft werden soll
	public InputField inputField;

	// Wenn "true" merkt sich das InputField den zuletzt eingegebenen Namen und schreibt diesen als Default Wert
	public bool rememberLastName = false;

	// Die normale Farbe der Image Komponente, falls Feld nicht leer
	private Color normalColor;

	// Der Text Inhalt im InputField 
	private string value;

	/// <summary>
	/// Liefert den aktuellen Inhalt vom InputField zurück
	/// </summary>
	/// <returns>The player name.</returns>
	public string GetValue() {
		return value;
	}

	// Use this for initialization
	void Start () {
		// Füge Listener für "OnValueChange" durch, der jedes mal Funktion "ValueChange" aufruft
		InputField.OnChangeEvent evt = new InputField.OnChangeEvent ();
		evt.AddListener (ValueChange);
		inputField.onValueChange = evt;

		// Lege Focus auf Eingabefeld
		inputField.Select ();

		// Normale Farbe = aktuelle Farbe
		normalColor = image.color;

		// Schreibe letzten Namen als Default-Name in InputField
		if (rememberLastName == true) {
			string lastName = gameObject.AddComponent<ScoreManager> ().GetCurName ();
			inputField.text = lastName;
			ValueChange (lastName);
		} else {
			ValueChange("");
		}
	}

	/// <summary>
	/// Wird aufgerufen, wenn sich der Inhalt des InputFields ändert
	/// </summary>
	public void ValueChange(string text) {
		this.value = text;
		if (value.Equals ("")) {
			image.color = errorColor;
		} else {
			image.color = normalColor;
		}
	}



}
