﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Steuer den Szenenwechsel vom Splash Screen zum hauptmenü
/// </summary>
public class CreditEndController : MonoBehaviour {
	
	// Zuständig für den Scenenwechsel
	public MenueStateController menueStateController;

	// Die Kamera, die bewegt wird
	public Transform movingCamera;

	// Letzte Position der bewegten Kamera
	public Vector3 endPos;

	// Gibt an, wie lange mit dem Szenenwechsel gewartet werden soll, wenn Kamera das Ende erreicht hat.
	public float waitBeforChange;

	// Hilfsvariable zur Zeitmessung
	private float timer = 0;

	// zustandsautomat
	private StateMachine stateMachine = new StateMachine();

	// Initialisiert das Script
	void Start() {
		stateMachine.SetState (WaitForEndPos);
	}

	// Update is called once per frame
	void Update () {
		// Falls Benutzer bestätigt, leite sofortigen Szenenwechsel ein
		if (Input.GetButton ("Submit") && Input.anyKeyDown) {
			// Wechsel zum Hauptmenü
			menueStateController.setNextScene("Menue_Main");
		}

		stateMachine.runState ();
	}

	/// <summary>
	/// Überprüft, ob Kamera bereits Endposition erreicht hat.
	/// Wenn ja wechsle zu Zustand "WaitBeforeSceneChanging"
	/// </summary>
	private void WaitForEndPos() {
		Vector3 curPos = movingCamera.transform.position;
		// Falls Spieler bestätigt (Enter, Space) oder Kamera die Endposition erreicht hat, beende Credits
		if(
			( (curPos.x <= (endPos.x + 1)) && (curPos.x >= (endPos.x - 1) ) ) &&
			( (curPos.y <= (endPos.y + 1)) && (curPos.y >= (endPos.y - 1) ) ) &&
			( (curPos.z <= (endPos.z + 1)) && (curPos.z >= (endPos.z - 1) ) )
		){
			stateMachine.SetState(WaitBeforeSceneChanging);
		}
	}

	/// <summary>
	/// Zustand, indem noch eine Zeit gewartet wird, bis zum Szenenwechsel
	/// </summary>
	private void WaitBeforeSceneChanging() {
		timer += Time.deltaTime;

		if (timer >= waitBeforChange) {
			// Wechsel zum Hauptmenü
			menueStateController.setNextScene("Menue_Main");
		}
	}

}