﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/** SceneChanger, der erst langsam eine Texture2D einblendet und dann Szene wechselt **/
public class FadeInSceneChanger : Fader, SceneChanger {
	
	private string nextScene;

	#region SceneChanger implementation
	public void startSceneTransition(string sceneName)
	{
		nextScene = sceneName;
		this.FadeIn();
	}
	#endregion

	 
	/** Einschubmethode für Fader
	 * Aktion die ausgeführt wird, falls FadeOut fertig **/
	protected override void FadeInComplete() {
		Application.LoadLevel(nextScene);
	}

}
