﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

public class Fader : MonoBehaviour {

	/** Bestimmt wie schnell Ein- oder Ausblenden erfolgt **/
	public float fadeSpeed = 0.6f;

	/** Zeit, die Fader nach Abschluss wartet, bis "FadedInComplete" oder "FadedInComplete" aufgerufen wird **/
	public float waitTime = 0.2f;

	// DIe Textur, die den Bildschirm verdeckt
	public Texture2D fadeOutTexture;

	/** Gibt an ob Script momentan arbeitet (Fade in oder fade out) **/
	private bool isFading = false;
	/** Gibt an ob Fader auf Coroutine Wartet **/
	private bool isWaiting = false;

	/** Aktueller Alpha Wert der Textur **/
	private float alpha;
	/** Richtung in der sich Alpha ändert **/
	private int fadeDir;

	// Use this for initialization
	void Awake () {

	}
	
	// Update is called once per frame
	void OnGUI () {
		// Führe Fading Prozess aus, falls Fader im Richtigen Status
		if (isFading) {
			alpha += fadeDir * fadeSpeed * Time.deltaTime;

			// Überprüft ob FadeIn bzw. FadeOut fertig ist
			if (fadeDir == 1 && alpha >= 0.9f) {
				alpha = 1f;
				isFading = false;
				isWaiting = true;
				StartCoroutine ("WaitForFadeInComplete");
			} else if (fadeDir == -1 && alpha <= 0.1f) {
				alpha = 0f;
				isFading = false;
				FadeOutComplete();
			}
			drawTexture (this.alpha);
		// Zeichne Textur mit letztem Alphawert, falls Fader im Richtigen Status
		} else if (isWaiting) {
			drawTexture(this.alpha);
		}
	}

	/** Blendet Bild langsam ein, wartet dann benutzerdefinierte Zeit bevor zuletzt Einschubmethode ausgeführt wird **/
	public void FadeIn() {
		alpha = 0f;
		fadeDir = 1;
		isFading = true;
	}

	/** Wartet benutzerdefinierte Zeit, blendet dann Bild langsam aus und führt zuletzt Einschubmethode aus **/
	public void FadeOut() {
		alpha = 1f;
		fadeDir = -1;
		isWaiting = true;
		StartCoroutine ("WaitStartFadeOut");
	}

	/** Legt die Textur mit gewünschtem Alpha-Wert über das ganze GUI **/
	private void drawTexture(float alpha) {
		GUI.color = new Color(GUI.color.r, GUI.color.g, GUI.color.b, alpha);
		GUI.depth = -1000;
		GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), fadeOutTexture);
	}

	/** Zeitverzögerter Aufruf von FadedInComplete **/
	private IEnumerator WaitForFadeInComplete()
	{
		yield return new WaitForSeconds(waitTime);
		isFading = false;
		FadeInComplete();
	}

	/** Zeitverzögerter Aufruf von FadedOutComplete **/
	private IEnumerator WaitStartFadeOut()
	{
		yield return new WaitForSeconds(waitTime);
		isWaiting = false;
		isFading = true;
	}

	/** Einschubmethode
	 * Aktion die ausgeführt wird, falls FadeIn fertig **/
	protected virtual void FadeInComplete() {
		;
	}

	/** Einschubmethode
	 * Aktion die ausgeführt wird, falls FadeOut fertig **/
	protected virtual void FadeOutComplete() {
		;
	}


}
