﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Regelt den Kontrollierten Szenenübergang in einem Menü
/// </summary>
public class MenueStateController : MonoBehaviour {

	/** SceneChanger reglt den ganzen Szenenübergang **/
	public SceneChanger sceneChanger;

	/** Gibt an ob die Szene gerade am wechseln ist **/
	private bool sceneChanging = false;

	// Use this for initialization
	void Start () {
		// Falls keine Referenz auf einen "SceneChanger" suche Komponente im gleichen gameObjekt
		if (sceneChanger == null) {
			sceneChanger = GetComponent<SceneChanger>();
		}
		// Falls Auch hier keinen "SceneChanger" gefunden, erstelle einen
		if (sceneChanger == null) {
			sceneChanger = gameObject.AddComponent<DirectSceneChanger>();
		}
	}

	/** Leitet den Szenenwechsel ein, Ausführung und Animation übernimmt "SceneChanger" **/
	public void setNextScene(string nextScene) {
		// Igoniere neuen Befehl, falls bereits im Szenenwechsel
		if (sceneChanging == false) {
			sceneChanging = true;
			sceneChanger.startSceneTransition(nextScene);
		}
	}

	/// <summary>
	/// Quits the game
	/// </summary>
	public void quitGame() {
		Application.Quit ();
	}

}
