﻿// ---------------------
//   Author:  P.Quell 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class BatteryDamage : MonoBehaviour
{
	public int startingBattery = 100;                            // The amount of battery the player starts the game with.
	public int currentBattery;                                   // The current battery the player has.
	public Slider BatterySlider;                                 // Reference to the UI's battery bar.
	public Image LoweringImage;                                   // Reference to an image to flash on the screen on being hurt.
	public float flashSpeed = 5f;                               // The speed the damageImage will fade at.
	public Color flashColour = new Color(1f, 0f, 0f, 0.1f);     // The colour the damageImage is set to, to flash.
	
	
	//bool isGameOver;                                                // GameOver.
	bool damaged;                                               // True when the player gets damaged.
	
	
	void Awake ()
	{
		// Set the initial battery of the player.
		currentBattery = startingBattery;
	}
	
	
	void Update ()
	{

		// If the player has just been damaged...
		if(damaged)
		{
			// ... set the colour of the LoweringImage to the flash colour.
			LoweringImage.color = flashColour;
		}
		// Otherwise...
		else
		{
			// ... transition the colour back to clear.
			LoweringImage.color = Color.Lerp (LoweringImage.color, Color.clear, flashSpeed * Time.deltaTime);
		}
		
		// Reset the damaged flag.
		damaged = false;


		// continuous dameging of the battery value 
		do {
			// Reduce the current battery by the damage amount.
			currentBattery --;
			
			// Set the battery bar's value to the current battery.
			BatterySlider.value = currentBattery;
		} while (Time.time % 5 == 0);

	}
	
	
	public void TakeDamage (int amount)
	{
		// Set the damaged flag so the screen will flash.
		damaged = true;
		
		// Reduce the current battery by the damage amount.
		currentBattery -= amount;
		
		// Set the battery bar's value to the current battery.
		BatterySlider.value = currentBattery;
		
		
		// If the player has lost all it's health and the death flag hasn't been set yet...
		/*if(currentBattery <= 0 && !isGameOver)
		{
			// ... it should die.
			//GameOver ();
		}*/
	}
	
	
	/*void GameOver ()
	{
		// Set the death flag so this function won't be called again.
		isGameOver = true;
		
		// Turn off any remaining shooting effects.
		playerShooting.DisableEffects ();
		
		// Tell the animator that the player is dead.
		anim.SetTrigger ("Die");
		
		// Set the audiosource to play the death clip and play it (this will stop the hurt sound from playing).
		playerAudio.clip = deathClip;
		playerAudio.Play ();
		
		// Turn off the movement and shooting scripts.
		playerMovement.enabled = false;
		playerShooting.enabled = false;
	}    */   
}
