﻿// ---------------------
//   Author:  P.Quell 
// ---------------------

using UnityEngine;
using System;

public class ClockManager : MonoBehaviour 
{
	private const float
		hoursToDegrees = 360f / 12f,
		minutesToDegrees = 360f / 60f,
		secondsToDegrees = 360f / 60f;
	
	public Transform hours, minutes, seconds;
	
	void Update () 
	{
		DateTime time = DateTime.Now;

		//directly setting the localRotation of the arms, using quaternions. Quaternion has a nice method we can use to define an arbitrary rotation
		hours.localRotation = Quaternion.Euler(0f, 0f, time.Hour * -hoursToDegrees);
		minutes.localRotation = Quaternion.Euler(0f, 0f, time.Minute * -minutesToDegrees);
		seconds.localRotation = Quaternion.Euler(0f, 0f, time.Second * -secondsToDegrees);
	}
}