﻿// ---------------------
//   Author:  P.Quell 
// ---------------------

using UnityEngine;
using System.Collections;


public class DamageTrigger : MonoBehaviour
{
	public float timeBatteryLowering = 0.5f;     // The time in seconds between each lowering.
	public int attackDamage = 30;               // The amount of health taken away per lowering.
	

	GameObject player;                          // Reference to the player GameObject.
	BatteryDamage playerBattery;                  // Reference to the player's battery.

	bool playerInRange;                         // Whether player is within the trigger collider and can be attacked.
	float timer;                                // Timer for counting up to the next attack.
	
	
	void Awake ()
	{
		// Setting up the references.
		player = GameObject.FindGameObjectWithTag ("Player");
		playerBattery = player.GetComponent <BatteryDamage> ();
	}
	
	
	void OnTriggerEnter (Collider other)
	{
		// If the entering collider is the player...
		if(other.gameObject == player)
		{
			// ... the player is in range.
			playerInRange = true;
		}
	}
	
	
	void OnTriggerExit (Collider other)
	{
		// If the exiting collider is the player...
		if(other.gameObject == player)
		{
			// ... the player is no longer in range.
			playerInRange = false;
		}
	}
	
	
	void Update ()
	{
		// Add the time since Update was last called to the timer.
		timer += Time.deltaTime;
		
		// If the timer exceeds the time between attacks, the player is in range and this enemy is alive...
		if(timer >= timeBatteryLowering && playerInRange )
		{
			// ... attack.
			Attack ();
		}
	}
	
	
	void Attack ()
	{
		// Reset the timer.
		timer = 0f;
		
		// If the player has health to lose...
		if(playerBattery.currentBattery > 0)
		{
			// ... damage the player.
			playerBattery.TakeDamage (attackDamage);
		}
	}
}