﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

/// <summary>
/// Steuert das optische UI Element "Firewall"
/// </summary>
public class FireWallController : MonoBehaviour {

	// DIe Bilder, die bei den jeweiligen Zuständen der Firewall angezeigt werden
	public Sprite firewallOnSprite;
	public Sprite firewallOffSprite;

	// Die Image Komponente, die je nach Zustand der Firewall verändert wird
	public Image firewallImage;

	// DIe Text Komponente, die je nach Zustand anderen Text (Onlone / offline) anzeigt
	public Text firewallText;

	// Gibt an ob Firewall an
	private bool isOnline = true;
	
	// Use this for initialization
	void Start() {
		TurnOn ();
	}

	/// <summary>
	/// Schaltet Firewall an
	/// </summary>
	public void TurnOn() {
		isOnline = true;
		firewallText.text = "Firewall online";
		firewallImage.overrideSprite = firewallOnSprite;
	}

	/// <summary>
	/// Schaltet Firewall aus
	/// </summary>
	public void TurnOff() {
		isOnline = false;
		firewallText.text = "Firewall offline";
		firewallImage.overrideSprite = firewallOffSprite;
	}

	/// <summary>
	/// Gibt an, ob Firewall gerade an (true) oder aus (false) ist
	/// </summary>
	/// <returns><c>true</c> if this instance is online; otherwise, <c>false</c>.</returns>
	public bool IsOnline() {
		return isOnline;
	}

}
