﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Basisklasse für alle Spieleevents wie z.B. "Batterie leer" oder "Hackangriff"
/// </summary>
public abstract class GameEvent : MonoBehaviour {

	// Script zur allg. Steuerung der GameEvents
	private GameEventController gameEventController;

	// Dient zum abspielen von Sounds und Musik
	protected MusicController audioController;

	/// <summary>
	/// Startet den Pre Teil des GameEvents (Teil vor dem Minispiel)
	/// </summary>
	/// <param name="gameEventController">Game event controller.</param>
	/// <param name="musicController">Music controller.</param>
	public void StartPreGameEvent(GameEventController gameEventController, MusicController musicController) {
		this.gameEventController = gameEventController;
		this.audioController = musicController;
		StartPreEvent ();
	}

	/// <summary>
	/// Startet den Post Teil des GameEvents (Teil nach dem Minispiel)
	/// </summary>
	/// <param name="gameEventController">Game event controller.</param>
	/// <param name="musicController">Music controller.</param>
	public void StartPostGameEvent(GameEventController gameEventController, MusicController musicController) {
		this.gameEventController = gameEventController;
		this.gameEventController = gameEventController;
		StartPostEvent ();
	}


	// Update is called once per frame
	// Delegiert an aktuelles Event
	void Update () {
		updateEvent ();
	}

	/// <summary>
	/// Beendet das GameEvent und übergibt dem "GameEventController" eine "GameEvent_EndAction" zurück, welche nach beenden des Minispiels aufgerufen werden muss
	/// </summary>
	/// <returns>The event over.</returns>
	public void GameEventOver() {
		// Leite Ende des GameEvents ein
		gameEventController.GameEventOver();
	}

	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird in jedem Frame einmal aufgerufen (Loop für Event)
	/// </summary>
	protected abstract void updateEvent ();
	
	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird aufgerufen um den Pre Teil des GameEvents zu initialisieren und zu starten
	/// Mit "Pre Teil des GameEvent" ist der Teil des GameEvents gemeint, der vor dem Minispiel ausgeführt wird
	/// </summary>
	protected abstract void StartPreEvent();

	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird aufgerufen um den Post Teil des GameEvents zu initialisieren und zu starten
	/// Mit "Post Teil des GameEvent" ist der Teil des GameEvents gemeint, nach vor dem Minispiel ausgeführt wird
	/// </summary>
	protected abstract void StartPostEvent();

	/// <summary>
	/// Muss einen einzigartigen Namen für jedes GameEvent zurückliefern
	/// </summary>
	/// <returns>The unique name.</returns>
	public abstract string GetUniqueName();

}

