﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;
using System.Collections.Generic;

/// <summary>
/// Verwaltet starten und beenden der GameEvents
/// Bindeglied zwischen Klasse "GameEvent" und "GameStateController"
/// Alle "GameEvent" GameObjects müssen direkte Kinder dieses Objekts sein
/// </summary>
public class GameEventController : MonoBehaviour {

	// Steuert Music und Sounds von GameEvents
	public MusicController audioController;

	// Gibt an ob ein GameEvent gerade läuft
	private bool gameEventRunning = false;

	// Liste aller GameObjecte, die GameEvents darstellen
	private List<GameObject> gameEventList;
	
	// Referenz auf GameObject, das GameEvent darstellt
	// Muss ein Script "GameEvent" als Komponente haben
	private GameObject curGameEvent;

	/// <summary>
	/// Gibt einen Wert zurück, der angibt ob das GameEvent noch läuft (Nicht fertig ist) <see cref="GameEventController"/> game event running.
	/// </summary>
	/// <value><c>true</c> if game event is running; otherwise, <c>false</c>.</value>
	public bool GameEventRunning
	{
		get{
			return gameEventRunning;
		}
	}

	/// <summary>
	/// Initalisiert das Script
	/// </summary>
	void Start() {
		// Initalisiere Zufallsgenarator
		Random.seed = System.DateTime.Now.GetHashCode();

		// Nehme alle aktiven Unterobjekte als GameEvents in eine Liste aus
		gameEventList = new List<GameObject> (5);
		for (int i = 0; i < transform.childCount; i++) {
			GameObject gEvt = transform.GetChild(i).gameObject;
			if(gEvt.activeSelf == true) {
				gameEventList.Add(gEvt);
				gEvt.SetActive(false);
			}
		}
		
	}

	/// <summary>
	/// Startet ein zufällige GameEvent
	/// </summary>
	/// <returns>Der Name des GameEvents.</returns>
	public string StartRandGameEvent() {
		gameEventRunning = true;
		
		// Aktiviere GameEvent durch aktiv setzten eines GameObjekts, welches das GameEvent darstellt
		int index = Mathf.RoundToInt(Random.Range (0, gameEventList.Count)) % gameEventList.Count;
		curGameEvent = gameEventList [index];
		curGameEvent.SetActive(true);
		
		// Starte GameEvent
		GameEvent gEvt = curGameEvent.GetComponent<GameEvent>();
		gEvt.StartPreGameEvent (this, audioController);

		return gEvt.GetUniqueName();
	}

	// Starte die Post Phase des Events (Nach dem Minispiel)
	public void StartPostGameEventAction() {
		gameEventRunning = true;

		curGameEvent.SetActive (true);

		curGameEvent.GetComponent<GameEvent> ().StartPostGameEvent (this, audioController);
	}

	/// <summary>
	/// GameEvent ist vorbei und wird nun Beendet
	/// </summary>
	/// <param name="win">Wenn <c>true</c> ist das Minispiel gewonnen worden</param>
	public void GameEventOver() {
		gameEventRunning = false;
		
		// Deaktiviere GameObject, das GameEvent darstellt
		curGameEvent.SetActive (false);
	}


}

