// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

public class Hack_EventLogic : GameEvent {

	// Zustandsautomat
	StateMachine stateMachine = new StateMachine();

	// Referenz auf den FirewallController, welcher Firewall an oder aus schalten kann
	public FireWallController firewallController;

	// Alarmsound, der abgespielt wird
	public AudioClip alarmSound;

	// Das Template UI Panel, das eine Warnung zeigt, wenn Auto gehackt wird
	public GameObject TEMPLATE_warningHackUI;

	// Zeit bis Auto geahckt wurde und Minispiel anfängt
	public float hackingTime = 5f;

	// Die erzeugte Instanz von "Template_warningBatteryUI" 
	private GameObject warningHackUI;

	// Hilfsvariable zur Zeitmessung
	private float t1;

	#region implemented abstract members of GameEvent
	
	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird aufgerufen um den Pre Teil des GameEvents zu initialisieren und zu starten
	/// Mit "Pre Teil des GameEvent" ist der Teil des GameEvents gemeint, der vor dem Minispiel ausgeführt wird
	/// </summary>
	protected override void StartPreEvent ()
	{
		t1 = 0;
		// Spiele Alarmsound
		audioController.StartNewClip (alarmSound, false);

		// Zeige Warnung, das Auto gehackt wird
		warningHackUI = Instantiate(TEMPLATE_warningHackUI);
		GameObject canvas = GameObject.FindGameObjectWithTag("Canvas");
		warningHackUI.transform.SetParent(canvas.transform, false);
		// Wechsle Zustand
		stateMachine.SetState (HackStateFirewallOn);
	}

	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird aufgerufen um den Post Teil des GameEvents zu initialisieren und zu starten
	/// Mit "Post Teil des GameEvent" ist der Teil des GameEvents gemeint, nach vor dem Minispiel ausgeführt wird
	/// </summary>
	protected override void StartPostEvent ()
	{
		firewallController.TurnOn ();
	}

	/// <summary>
	/// Einschubmethode für konkretes Event
	/// Wird in jedem Frame einmal aufgerufen (Loop für Event)
	/// </summary>
	protected override void updateEvent ()
	{
		stateMachine.runState ();
	}

	/// <summary>
	/// Muss einen einzigartigen Namen für jedes GameEvent zurückliefern
	/// </summary>
	/// <returns>The unique name.</returns>
	public override string GetUniqueName ()
	{
		return "Hack";
	}

	#endregion

	/// <summary>
	/// Zustand, in dem des Auto gehackt wird und Firewall noch an ist
	/// </summary>
	private void HackStateFirewallOn() {
		t1 += Time.deltaTime;

		// Scahlte nach dem halben Hackvorgang die Firewall ab
		if(t1 >= (hackingTime / 2)) {
			firewallController.TurnOff();
			stateMachine.SetState(HackStateFirewallOff);
		}
	}

	/// <summary>
	/// Zustand, in dem des Auto gehackt wird
	/// </summary>
	private void HackStateFirewallOff() {
		t1 += Time.deltaTime;

		// Wenn Zeit abgelaufen beende Event und starte Minispiel
		if (t1 >= hackingTime) {
			audioController.StoppMusik();
			DestroyImmediate(warningHackUI);
			GameEventOver();
		}
	}


}
