﻿// ---------------------
//   Author:  K.Wacker 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class PulsatingScriptRawImage : MonoBehaviour {

	// Objekt, das pulsieren soll
	RawImage objectToPulsate;
	//tatsächliche Referenz auf Farbe des zu verändernden Objekts
	Color textureColor;
	//temporärer Speicher für neue Farbe
	Color tmpColor;

	/// <summary>
	/// Ober- / Untergrenze, zwischen denen Alpha pulsiert und Dauer der Pulsation
	/// </summary>
	public float minAlpha = 0.2f;
	private float maxAlpha;		//maxAlpha = eingestelltes Alpha des UI-Elements
	public float fadeSpeed = 4.0f;
	public float changeMargin = 0.05f;	//Toleranz der Grenzen (Absolutwert Alpha um den max von Grenzen abweichen darf)

	//momentanes Ziel für lerp
	private float targetAlpha;


	// Use this for initialization
	void Awake () {
		objectToPulsate = gameObject.GetComponent<RawImage> ();
		textureColor = objectToPulsate.color;
		//Debug.LogError (textureColor.ToString());
		maxAlpha = textureColor.a;
		targetAlpha = maxAlpha;

		tmpColor = textureColor;
		tmpColor.a = minAlpha;
		textureColor = tmpColor;
		//Debug.LogError (textureColor.ToString());

	}
	
	// Update is called once per frame
	void Update () {
		//Image img = gameObject.GetComponent<Image> ();
		//img.color = UnityEngine.Color.blue;

		//textureColor.a = Mathf.Sin (Time.time * 1.0f);
		//textureColor.a = Mathf.Lerp (0, 200, 1.0f);
		//gameObject.GetComponent<Image> ().color = textureColor;
		tmpColor = pulsateAlpha (tmpColor);
		textureColor = tmpColor;
		objectToPulsate.color = tmpColor;
		//Debug.LogError (textureColor.ToString());
	}


	/// <summary>
	/// Pulsiert den Alphawert zw. den public Parametern
	/// </summary>
	public Color pulsateAlpha(Color col) {

		// Alternative mit Color.Lerp
		//Color targetColor = col;
		//targetColor.a = targetAlpha;
		//col = Color.Lerp (col, targetColor, fadeSpeed * Time.deltaTime);

		// Alphawert zum Zielwert lerpen
		col.a = Mathf.Lerp (col.a, targetAlpha, fadeSpeed*Time.deltaTime);

		// Überprüfen, ob ZielAlpha angepasst werden muss
		CheckTargetAlpha (col);

		return col;

	}


	private void CheckTargetAlpha(Color col) {

		// Wenn MomentanAlphaWert die Grenze im Rahmen der Toleranz changeMargin erreicht hat, Richtung umdrehen
		if (Mathf.Abs (targetAlpha - col.a) < changeMargin) {

			// Wenn Obergrenze erreicht, dann neues Ziel Untergrenze
			if (targetAlpha == maxAlpha) targetAlpha = minAlpha;
			//Sonst neues Ziel Untergrenze
			else targetAlpha = maxAlpha;
		}


	}

}
