﻿// ---------------------
//   Author:  K.Wacker 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class GameOverUIScript : MonoBehaviour {

	private ScoreManager scoreManager;
	//Textfeld mit Score
	private Text scoreText;


	// Use this for initialization
	void Start () {

		scoreManager = GameObject.FindObjectOfType<ScoreManager>();
		if (scoreManager == null) {
			Debug.LogError ("You forgot to add the score manager component to a game object");
			return;
		}

		scoreText = gameObject.transform.Find ("ScoreText").GetComponent<Text> ();

		
		scoreText.text = scoreManager.GetCurScore ().ToString ();
	}
	
	// Update is called once per frame
	void Update () {

	}




}
