// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

namespace Minigames.PushButtons
{
	public class PushButtons_GameLogic : Minigame
	{

		/*
	 	* Variablen, um Spiel zu konfigurieren
	 	*/

		// Zeitdauer, die Spieler durchhalten muss um das Spiel zu gewinnen
		public float gamePeriod = 30;

		// Gibt an, wie voll die Batterie bei Spielstart ist
		public float batteryStartLevel = 25f;

		// Gibt an um wieviel die Batterie erhöht wird, falls richtige Taste gedrückt wird
		public float BAT_incPerRightButton = 2f;

		// Gibt an um wieviel die Batterie verringert wird, falls eine falsche Taste gedrückt wird (Positiver Wert angeben)
		public float BAT_DecWrongButton = 2f;

		// Gibt an um wieviel Prozent die Batterie pro Sekunde entläd
		// POSITIVER WERT
		public float BAT_DecPerSec = 5f;

		// Gibt an, um wie viel sich der Score erhöht, falls richtige Taste gedrückt (Positiver Wert)
		public float SCORE_IncPerRightButton = 2f;

		// Gibt an, um wie viel sich der Score verringert, falls falsche Taste gedrückt (Positiver Wert)
		public float SCORE_DecWrongButton = 2f;

		// Gibt an, mit welchem Wert der Score Multipliziert wird, wenn Battery bei 100% angekommen (Danach reduzierung der Batterie)
		public float SCORE_multiBatMax = 1.1f;

		// Tasten, welche per Zufall zum drücken ausgewählt werden
		public char[] aviableKeys = {'w', 'a', 's', 'd', 'e', 'f'};

		// Chance, dass zu drückende Taste geändert wird
		public float probableKeyChange = 0.6f;

		// Intervall, nachdem ein Tastenwechsel stattfinden kann
		public float keyChangeDuration = 4f;

	

		/*
		 * Andere
		 */ 

		// Referenez auf UIConnector zum Datenaustausch zw. UI und Controller
		private PushButtons_UIConnector uiConnector;

		// Steuert den Ablauf des Minispiels
		StateMachine stateMachine = new StateMachine ();


		/*
	 	* Hilfsvariablen
	 	*/
		// Speichert die bisher vergangene Zeit um eine Zeitdauer für Spielelogik zu ermitteln
		private float timer1, timer2;

		// Taste die Spieler aktuell drücken muss
		private char curKey;

		// Gibt die aktuelle Ladung der Batterie an
		private float batteryLevel;

		#region implemented abstract members of Minigame
		// Wird beim Spielstart zur Initialisierung gestartet
		protected override void InitGame ()
		{
			Random.seed = System.DateTime.Now.GetHashCode();
			uiConnector = GetComponent<PushButtons_UIConnector> ();
			uiConnector.Init ();
			batteryLevel = batteryStartLevel;
			uiConnector.setBatteryLevel (batteryLevel);
			setNewKey ();
			timer1 = 0;
			timer2 = 0;
			stateMachine.SetState (userInputState);
		}

		/// <summary>
		/// Einschubmethode für konkretes Minispiel
		/// Wird jeden Frame von Vaterklasse "Minigame" aufgerufen
		/// </summary>
		protected override void updateMinigame ()
		{
			stateMachine.runState ();
		}
		#endregion

		/// <summary>
		/// Zustand in dem Spieler Taste schnellstmöglich drücken muss
		/// </summary>
		private void userInputState ()
		{
			// Ruft gedrückte Tasten ab und reagiert entprechend (Energie/ Scrore wird erhöht bzw. verringert)
			KeyPressedAction ();

			// Überprüfe ob Spielzeit abgelaufen
			timer1 += Time.deltaTime;
			// Zeit vorbei -> Spiel gewonnen
			if (timer1 >= gamePeriod) {
				GameOver(true);
				return;
			}

			batteryLevel -= BAT_DecPerSec * Time.deltaTime;
			// Wenn Batterie leer -> Spiel verloren
			if (batteryLevel <= 0) {
				GameOver(false);
				return;
			}
		// Wenn Batterie ganz voll -> Extrapunkte
		else if (batteryLevel >= 100) {
				ScoreController.MultiplyScore(SCORE_multiBatMax);
				batteryLevel -= 10;
			}

			// Überprüfe ob Taste getauscht werden muss
			timer2 += Time.deltaTime;
			if (timer2 >= keyChangeDuration) {
				timer2 = 0;
				if (Random.value <= probableKeyChange) {
					setNewKey ();
				}
			}

			// Aktuallisiere UI
			uiConnector.setBatteryLevel (batteryLevel);
			uiConnector.setTime (gamePeriod - timer1);
		}

		/// <summary>
		/// Liefert eine zufälliges Zeichen dem Array "aviableKeys"
		/// </summary>
		private void setNewKey ()
		{
			int rndVal;
			// Wiederholde bis neue Taste != alte Taste
			do {
				// Ermittle zufälligen Arrayindex für "aviableKeys"
				rndVal = Random.Range(0, aviableKeys.Length);
			} while(aviableKeys [rndVal] == curKey);
			// Setzte neues Zeichen
			curKey = aviableKeys [rndVal];
			// Zeige neues Zeichen auch im UI
			uiConnector.setNewKeylabel (curKey);
		}

		/// <summary>
		// Rufe gedrückte Tasten ab und reagiere entprechend (Energie/ Scrore wird erhöht bzw. verringert)
		/// </summary>
		/// <param name="c">C.</param>
		public void KeyPressedAction()
		{
			string pressedKeys = uiConnector.GetPressedKeys();

			// Überprüfe ob eine der gedrückten Tasten die gewünschte ist
			foreach (char key in pressedKeys) {

				// Spieler drückt richtige Taste
				if (key == curKey) {
					batteryLevel += BAT_incPerRightButton;
					ScoreController.AddScore (SCORE_IncPerRightButton);

					// Spieler drückt NICHT die richtige Taste
				} else {
					// Falls Spieler eine falsche Taste drückt 
					foreach(char c in aviableKeys) {
						if(c == key) {
							batteryLevel -= BAT_DecWrongButton;
							ScoreController.AddScore (-SCORE_DecWrongButton);
							return;
						}
					}
				}
			}
		}

	}


}

