// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

namespace Minigames.PushButtons
{

/// <summary>
/// Regelt für das Minispiel PushButton die Kommunikation mit dem UI
/// </summary>
	public class PushButtons_UIConnector : UIConnector
	{

		// Panel auf dem Minispiel optisch dargestellt wird
		private GameObject panel;
		// Button, der vom Spieler gedrückt wird
		private GameObject button;
		// Beschriftungsfeld des Buttons, der vom Spieler gedrückt wird
		private Text keyLabel;
		// Transform für aktuellen Batterystand
		private RectTransform batteryBar;
		// Beschriftungsfeld für den aktuellen Batteriestand
		private Text batteryLabel;
		// Beschriftungsfeld für verbleibende Spielzeit
		private Text remainingTime;


		// Initialisiert das Script
		public void Init ()
		{
			panel = minigameUI;
			button = panel.transform.Find ("Button").gameObject;
			keyLabel = panel.transform.Find ("Button/Text").GetComponent<Text> ();
			batteryBar = panel.transform.Find ("EnergyBar/Charge").GetComponent<RectTransform> ();
			batteryLabel = panel.transform.Find ("EnergyBar/Label").GetComponent<Text> ();
			remainingTime = panel.transform.Find ("Time/Text").GetComponent<Text> ();
		}

		/// <summary>
		/// Liefert die gedrückten Tasten zurück
		/// </summary>
		/// <returns>The pressed keys.</returns>
		public string GetPressedKeys ()
		{
			// Verhindere gedrückthalten der Taste
			if (Input.anyKeyDown == true) {
				// Gehe alle gedrückten Tasten durch
				return Input.inputString;
			}
			// Falls keine Tasten gedrückt -> Gebe leeren String zurück
			return "";
		}

		/// <summary>
		/// Der Eingabeknopf des Spielers zeigt ein neues Zeichen an
		/// </summary>
		/// <param name="c">C.</param>
		public void setNewKeylabel (char c)
		{
			keyLabel.text = "" + c;
		}

		/// <summary>
		/// Ändert den Inhalt des Zeitefeldes auf die neue Zeit ab
		/// </summary>
		/// <param name="t">T.</param>
		public void setTime (float t)
		{
			int sek = (int)Mathf.Round (t);
			remainingTime.text = "" + sek;
		}

		/// <summary>
		/// Zeichnet den Batterybalken entsprechend dem übergebenen Wert
		/// </summary>
		/// <param name="level">Prozentwert zwischen 0 und 1</param>
		public void setBatteryLevel (float level)
		{
			batteryLabel.text = Mathf.Round (level) + "%";
			level = level * 0.01f;
			Vector2 oldAnchor = batteryBar.anchorMax;
			oldAnchor.y = level;
			batteryBar.anchorMax = oldAnchor;
		}

	}

}
