﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;
using System.Collections;

/// <summary>
/// Regelt für das Minispiel RememberString die Kommunikation mit dem UI
/// </summary>
public class RememberText_UIConnector : UIConnector {

	// Panel auf dem Minispiel optisch dargestellt wird
	private GameObject panel;
	
	// Komponenten des Eingabefelds, welches entweder Text angezeigt oder Spieler Text eingeben muss
	// ____________________________________
	// Script, dass Inputfield steuert
	private InputField inputFieldScript;
	// Text, der als Platzhalter im Feld steht (Ist grau und undurchsichtig)
	private Text inputFieldPlaceholder;
	// Text, der im Inputfield steht (Dick und Schwarz)
	private Text inputFieldText;
	// _____________________________________

	// Stellt die Beschriftung für das Eingabefeld da
	// Fordert entweder zur Eingabe auf oder weist darauf hin, das Benutzer sich den Text merken soll
	private Text inputFieldLabel;

	// Text, der die noch verbleibende Zeit anzeigt
	private Text timeField;

	// Gibt an ob Spieler in diesem Frame "Bestätigen" gedrückt hat
	private bool submit;
	// Text, der gerade im InputField steht
	private string userInput;

	float timer;

	/// <summary>
	/// Initialisiert das Script
	/// </summary>
	public void Init ()
	{
		// Setze Werte zurück
		userInput = "";
		submit = false;
		timer = 0;

		panel = minigameUI;

		// Suche Referenzen im UI Panel
		GameObject inputField = panel.transform.Find ("InputField").gameObject;
		inputFieldScript = inputField.GetComponent<InputField> ();
		inputFieldPlaceholder = inputField.transform.Find ("Placeholder").GetComponent<Text> ();
		inputFieldText = inputField.transform.Find ("Text").GetComponent<Text> ();

		// Füge Eventhandler hinzu. Wird ausgelöst, wenn Spieler eine Taste eintippt
		inputField.GetComponent<InputField> ().onValueChange.AddListener (UpdateInputText);

		inputFieldLabel = panel.transform.Find ("InputFieldLabel/Text").GetComponent<Text> ();
		timeField = panel.transform.Find ("TimeField/Text").GetComponent<Text> ();
	}

	/// <summary>
	/// Wird vom InputField ausgelöst, wenn sich dessen Inhalt(Text) ändert
	/// </summary>
	/// <param name="">.</param>
	private void UpdateInputText(string str) {
		userInput = str;
	}

	/// <summary>
	/// Liefert einen Boolschen Wert zurück, der angibt ob "Bestätigen" gedrückt wurde
	/// </summary>
	/// <returns><c>true</c> if this instance is submit pressed; otherwise, <c>false</c>.</returns>
	public bool HasPlayerSubmitted() {
		return submit;
	}

	/// <summary>
	/// Gibt den Inhalt des InputFields zurück
	/// </summary>
	/// <returns>The input text.</returns>
	public string GetUserInputText() {
		return userInput;
	}

	/// <summary>
	/// Wird ein mal pro Frame ausgeführt
	/// Setzte die Variable "submit" auf true, sobald "Bestätigen" gedrückt wurde
	/// </summary>
	void Update() {
		timer += Time.deltaTime;
			if (Input.GetButton ("Submit") && Input.anyKeyDown && timer > 0.25) {
				submit = true;
			}
	}

	/// <summary>
	/// Zeigt im entsperchnden Feld die Zeit an
	/// </summary>
	/// <param name="t">T.</param>
	public void ShowTime(float t) {
		int sek = (int)Mathf.Round (t);
		timeField.text = "" + sek;
	}

	/// <summary>
	/// Bewirkt, dass das InputField nur zur Anzeige eines Textes dient
	/// Benutzer kann Text nur lesen und nicht eingeben
	/// </summary>
	/// <param name="text">Text, den InputField anzeigt</param>
	public void SetReadState(string shownText) {
		// Setze Werte zurück
		userInput = "";
		submit = false;
		timer = 0;


		// Deaktiviere Eingabelogik
		inputFieldScript.DeactivateInputField();
		inputFieldScript.enabled = false;

		// Setze richtigen Text
		inputFieldPlaceholder.text = "";
		inputFieldText.text = shownText;
		inputFieldLabel.text = "Merke dir den Text ...";
	}

	/// <summary>
	/// Bewirkt, dass das InputField nur zur Eingabe eines Textes dient
	/// Benutzer kann jetzt Text eingeben
	/// </summary>
	public void SetInputState() {
		submit = false;
		timer = 0;

		inputFieldScript.enabled = true;
		inputFieldScript.ActivateInputField ();

		inputFieldScript.text = "";
		inputFieldPlaceholder.text = "Zahl hier eingeben";
		inputFieldLabel.text = "Tippe die gemerkte Zahl ein:";
		inputFieldScript.Select();

	}

}
