﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Steuert den Ablauf des Tutorials, welches vor dem Start der Minispiele angezeigt wird
/// Man kann keine, bis beliebig viele Panels mit Spielerhinweisen anzeigen lassen.
/// </summary>
public class TutorialController : MonoBehaviour {

	// 0 bis * Panels, auf denen das Minispiel erklärt wird
	public GameObject[] tutorialPanels = new GameObject[0];

	// Gibt an, bei welches Panel des Tutorials gerade angezeigt wird
	private int panelIndex;

	// Gibt an ob das Tutorial aktiv ist (angeziegt wird), oder nicht
	private bool tutorialRunning = false;

	// Das aktuell angezeigt TutorialPanel
	private GameObject curPanel;

	// Referenz auf das Canvas der UI
	Transform canvas;

	// Sorgt dafür, das erst nach einer Gewissen Zeit das 
	private int delay;

	/// <summary>
	/// Startet das Tutorial
	/// </summary>
	/// <returns><c>true</c>, if tutorial was started (Mind 1 Panel), <c>false</c> otherwise ( Kein Panel zugewiesen).</returns>
	public bool StartTutorial() {
		panelIndex = 0;
		canvas = GameObject.FindGameObjectWithTag("GameUI").transform.parent;

		// Starte Tutorial nur, falls mind 1 Panel verfügbar
		if (tutorialPanels.Length > 0 && tutorialPanels[0] != null) {
			tutorialRunning = true;

			// Deaktiviere alle anderen Panels auf gleicher Ebene
			for(int i = 0; i < canvas.childCount; i++) {
				canvas.GetChild(i).gameObject.SetActive(false);
			}
			curPanel = Instantiate(tutorialPanels[0]);
			curPanel.transform.SetParent(canvas, false);

		} else {
			tutorialRunning = false;
		}
		return tutorialRunning;
	}

	/// <summary>
	/// Beendet das Tutorial und stellt alte Fenster wieder her
	/// </summary>
	public void EndTutorial() {
		if (tutorialRunning == true) {
			DestroyImmediate (curPanel);
			// Aktiviere alle anderen Panels auf gleicher Ebene
			for (int i = 0; i < canvas.childCount; i++) {
				canvas.GetChild (i).gameObject.SetActive (true);
			}
			tutorialRunning = false;
		}
	}

	/// <summary>
	/// Zeigt das nächste Panel des Tutorials, falls verfügbar
	/// </summary>
	private void ShowNextPanel() {
		panelIndex++;
		// Falls noch weitere Panels vorhanden starte dieses, sonst beende Tutorial
		if (tutorialPanels.Length > panelIndex && tutorialPanels [panelIndex] != null) {
			DestroyImmediate(curPanel);
			curPanel = Instantiate(tutorialPanels[panelIndex]);
			curPanel.transform.SetParent(canvas, false);
		} else {
			EndTutorial();
		}
	}

	/// <summary>
	/// Überprüft Regelmäßig ob bereits bestätigt wurde
	/// </summary>
	void Update() {
		if (CheckUserSubmitAction() == true) {
			ShowNextPanel();
		}
	}

	/// <summary>
	/// Überprüft ob Benutzer gerade eine Interaktion ausführt, die zum schließen des Tutorial Panels führt
	/// (z.B. Enter, Space, Mausklick, ...)
	/// </summary>
	/// <returns><c>true</c>, if user perfomrs a submit action, <c>false</c> otherwise.</returns>
	private bool CheckUserSubmitAction() {
		if( (Input.GetButton ("Submit") && Input.anyKeyDown == true) ||
		   Input.GetMouseButtonDown(0) || Input.GetMouseButtonDown(1) || Input.GetMouseButtonDown(2) ) {
			return true;
		}
		return false;
	}

	/// <summary>
	/// Gibt an ob das Tutorial gerade aktiv ist (Angeziegt wird)
	/// </summary>
	/// <returns><c>true</c> if this instance is tutorial running; otherwise, <c>false</c>.</returns>
	public bool IsTutorialRunning() {
		return tutorialRunning;
	}
}
