﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

public class UIConnector : MonoBehaviour {
	
	/// <summary>
	/// Das spezifische Panel (Zeichenfläche) das dieses Minispiel verwendet
	/// -> Nur die Vorlage / template
	/// </summary>
	public GameObject minigameUITemplate;

	// Instanz des "gamePanels", dass in das UI geladen wird
	protected GameObject minigameUI;

	/// <summary>
	/// Erzeuge UI Panel für das Minigame
	/// </summary>
	/// <returns>Referenz auf das Erzeugte Mingame UI GameObject.</returns>
	public GameObject CreateMinigameUI() {
		GameObject parent = GameObject.FindWithTag ("GameUI");
		minigameUI = Instantiate(minigameUITemplate);
		minigameUI.transform.SetParent(parent.transform, false);
		return minigameUI;
	}

	// Zerstört das UI Panel des Minispiels
	public void DestroyMinigameUI() {
		DestroyImmediate (minigameUI, false);
	}


}
