﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Liefert genau gleiche Funktionalität wie "ScoreMover", nur das die Bewegung um eine Zeitspanne verzögert werden kann
/// </summary>
public class DelayedScoreMover : ScoreMover
{
	// Gibt die Wartezeit an, bis Bewegung gestartet wird
	private float waitTime;
		
	/// <summary>
	/// Initializes a new instance of the <see cref="DelayedScoreMover"/> class.
	/// </summary>
	/// <param name="movedElement">Moved element.</param>
	/// <param name="endPos">End position.</param>
	/// <param name="movingSpeed">Moving speed.</param>
	/// <param name="waitTime">MDie zeitverzögerung bis zum Start der Bewegung</param>
	public DelayedScoreMover (RectTransform movedElement, Vector3 endPos, float movingSpeed, float waitTime)
			: base(movedElement, endPos, movingSpeed)
	{
		this.waitTime = waitTime;
		movedElement.gameObject.SetActive(false);
	}

	/// <summary>
	/// Falls Wartezeit abgelaufen, wird das Element bewegt, falls dieses noch nicht am Ziel ist.
	/// Rückgabewert gibt an, ob Element schon das Bewegungsziel erreicht hat 
	/// Return false == Element hat Ziel erreicht, daher keine Bewegung mehr
	/// </summary>
	/// <returns>true</returns>
	/// <c>false</c>
	public override bool MoveElement ()
	{
		// Falls Zeit noch nicht abgelaufen -> Verringere Zeit und gebe "true" zurück, als Zeichen, das Bewegung noch nicht abgeschlossen
		if (waitTime > 0) {
			waitTime -= Time.deltaTime;
			return true;
		}
		movedElement.gameObject.SetActive(true);
		return base.MoveElement ();
	}

}
