﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

// Funktion die einen ausführbaren Zustand darstellt
public delegate float ScoreAction(float curScore);

/// <summary>
/// Liefert genau gleiche Funktionalität wie "ElementMover", nur speziell auf das Bewegen von Score Elementen zugeschnitten
/// </summary>
public class ScoreMover : ElementMover {

	// Eine Funktion, die angibt wie der Minispiel Score nach abschluss verändert werden soll
	public ScoreAction ScoreEndAction;

	/// <summary>
	/// Initializes a new instance of the <see cref="ScoreMover"/> class.
	/// </summary>
	/// <param name="movedElement">Moved element.</param>
	/// <param name="endPos">End position.</param>
	/// <param name="movingSpeed">Moving speed.</param>
	public ScoreMover(RectTransform movedElement, Vector3 endPos, float movingSpeed = 0.1f)
		: base(movedElement, endPos, movingSpeed)
	{}


}
