// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using System.Collections;

// Funktion die einen ausführbaren Zustand darstellt
public delegate void GameState();

public class StateMachine {

	// Stellt den aktuellen Zustand dar
	protected GameState curState;

	// Konstruktor -> Setzt Idle State
	public StateMachine() {
		setIdleState ();
	}

	// Update is called once per frame
	// Delegiert an aktuellen Spielezustand
	public void runState () {
		curState();
	}
	
    /// <summary>
    /// Setzt einen neuen Ausführbaren Zustand
    /// </summary>
    /// <param name="state">State.</param>
	public void SetState(GameState state) {
		curState = state;
	}

	/// <summary>
	/// Setzt den Idle (Leerlauf) Zustand
	/// </summary>
	public void setIdleState() {
		curState = delegate() {
			;
		};
	}

}
