﻿// ---------------------
//   Author:  O.Feucht 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

/// <summary>
/// Dient zum Skalieren  eines GameObjekts bei einem Event
/// Wichtig: Script sollte im GameObjekt liegen, das Skaliert werden soll
/// </summary>
public class HighlightButton : MonoBehaviour {
	
	// Skalierungsfaktor in X- und Y-Richtung
	public float scaleX = 0.05f;
	public float scaleY = 0.025f;

	// Ursprüngliche Größe des Buttons
	Vector2 vecMin, vecMax;

	// Referenz auf Rectranbsform des Buttons
	RectTransform button;

	// Use this for initialization
	void Start () {
		button = GetComponent<RectTransform> ();
		vecMin = button.anchorMin;
		vecMax = button.anchorMax;
	}

	/// <summary>
	/// Skaliert Button, bei "MouseOver" Event.
	/// </summary>
	public void MouseIn() {
		// Berechne neue X-Koordinaten
		float xMin = vecMin.x - (vecMin.x * scaleX);
		float xMax = vecMax.x + (vecMax.x * scaleX);

		// Berechne neue Y-Kooridinaten
		float yMin = vecMin.y - (vecMin.y * scaleY);
		float yMax = vecMax.y + (vecMax.y * scaleY);

		// Setze neue X- und Y-Koordinaten
		button.anchorMin = new Vector2 (xMin, yMin);
		button.anchorMax = new Vector2 (xMax, yMax);
	}

	// Skaliert Button bei "MouseOut" Event zur Ursprünglichen Größe zurück
	public void MouseOut() {
		button.anchorMin = vecMin;
		button.anchorMax = vecMax;
	}



}
