﻿// ---------------------
//   Author:  K.Wacker 
// ---------------------

using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class HighScoreList : MonoBehaviour {

	public GameObject highScoreEntryPrefab;

	private ScoreManager scoreManager;

	// Use this for initialization
	void Start () {

		scoreManager = GameObject.FindObjectOfType<ScoreManager>();
		if (scoreManager == null) {
			Debug.LogError ("You forgot to add the score manager component to a game object");
			return;
		}
	}


	// Update is called once per frame
	void Update () {

		//Wenn Änderung an den Highscores vorgenommen wurde, aktualisiere das Scoreboard
		if (scoreManager.getHasChanged () == true) {
			scoreManager.setHasChanged(false);
			refreshList ();
		}
	}


	//Baut Einträge des Scoreboards auf (basierend auf highScoreEntryPrefab als Child von High Score List)
	void refreshList() {

		//Namen und Scores der Highscoreeinträge holen
		string[] names = scoreManager.GetNames ();
		int[] scores = scoreManager.getScores ();

		//zerstört alte Highscoreeinträge
		while (this.transform.childCount > 0) {
			Transform c = this.transform.GetChild (0);
			c.SetParent (null);  //Parent entfernen -> für Zerstörung markiert
			Destroy (c.gameObject);
		}

		//Neue Highscoreeinträge aufbauen
		for (int i=0; i<10; i++) {
			GameObject go = Instantiate (highScoreEntryPrefab);
			go.transform.SetParent (this.transform);
			go.transform.Find ("Name").GetComponent<Text>().text = names[i];
			//Bei Score 0 kein Anzeigen von Punkten
			if(scores[i]>0) {
				go.transform.Find ("Score").GetComponent<Text>().text = scores[i].ToString();
			} else {
				go.transform.Find ("Score").GetComponent<Text>().text = "";
			}
		}
	}

	


}
