﻿// ---------------------
//   Author:  K.Wacker 
// ---------------------

using UnityEngine;
using System.Collections;

public class ScoreManager : MonoBehaviour {

	//Zeigt ob Scores in PlayerPrefs verändert wurden
	private bool hasChanged = false;

	//Speichert Score/Name während aktuellen Spiels temporär
	private int currentScore = 0;
	private string currentName = "";

	//Beinhalten Namen/Scores in nach Punktzahl geordneter Reihenfolge (aus PlayerPrefs ausgelesen)
	private string[] names;
	private int[] scores;


	/// <summary>
	/// Setzt den Namen des Spielers
	/// </summary>
	/// <param name="name">Name.</param>
	public void SetCurName(string name) {
		currentName = name;
		PlayerPrefs.DeleteKey("CurrentName");
		PlayerPrefs.SetString ("CurrentName", name);
	}

	public string GetCurName() {
		currentName = PlayerPrefs.GetString ("CurrentName");
		return currentName;
	}





	// Use this for initialization
	void Start () {

		init ();

	}

	//Stellt sicher, dass Scores auf jeden Fall initialisiert werden
	private void init() {

		if (names != null)
			return;

		names = new string[] {"","","","","","","","","",""};
		scores = new int[] {0,0,0,0,0,0,0,0,0,0}; 
		StoreScore ("", 0);

	}

	// Update is called once per frame
	void Update () {
		if (hasChanged)
			refreshScores ();

	}

	/// <summary>
	/// Gets the current score.
	/// </summary>
	/// <returns>The current score.</returns>
	public int GetCurScore() {
		return currentScore;
	}


	//Lädt in PlayerPrefs gespeicherte Scores neu in Variable ein
	public void refreshScores() {
		init ();

		int i=0;

		for (i=0; i<10; i++) {
			if(PlayerPrefs.HasKey (i+"HScore")) {
				names[i]=PlayerPrefs.GetString (i+"HScoreName");
				scores[i]=PlayerPrefs.GetInt (i+"HScore");						
			}else {
				names[i]="";
				scores[i]=0;
			}
		}
	}


	//Inkrementiert Score des aktuellen Spiels um inc
	public void AddScore(int inc) {
		currentScore += inc;
	}

	//Inkrementiert Score des aktuellen Spiels um inc
	public void SetCurScore(int amount) {
		currentScore = amount;
	}


	//Überprüft, ob Score hoch genug für Eintrag in Scoreboard und fragt ggf. Name des Spielers ab
	public void checkTopTen() {
		init ();

		if (currentScore > scores [9]) {
			//currentName durch Eingabe in Erfahrung bringen
			//StoreScore (currentName, currentScore);
		}
	}


	/// <summary>
	/// Speichert CurrentScore mit CurrentName in PlayerPrefs
	/// </summary>
	public void StoreScore() {
		string curName = GetCurName ();
		StoreScore (curName, currentScore);
	}

	//Trägt Score an richtiger Stelle ins Scoreboard in den PlayerPrefs ein, wenn Score in Top-Ten
	public void StoreScore(string name, int score) {

		int oldScore = 0;
		string oldName = "";
		int newScore = score;
		string newName = name;

		int i;

		hasChanged = true;

		for (i=0; i<10; i++) {
			if(PlayerPrefs.HasKey (i+"HScore")) {
				//Wenn neuer Score höher als der gespeicherte Score an Stelle i -> ersetzen
				if(PlayerPrefs.GetInt (i+"HScore")<newScore) {
					oldScore = PlayerPrefs.GetInt (i+"HScore");
					oldName = PlayerPrefs.GetString (i+"HScoreName");
					PlayerPrefs.SetInt (i+"HScore", newScore);
					PlayerPrefs.SetString (i+"HScoreName", newName);
					newScore = oldScore;
					newName = oldName;
				}
			}else {
				PlayerPrefs.SetInt(i+"HScore",newScore);
				PlayerPrefs.SetString(i+"HScoreName",newName);
				newScore = 0;
				newName = "";				
			}
		}
		refreshScores ();
	}


	//Löscht alle Einträge des Scoreboards
	public void ResetScores() {

		int i;

		hasChanged = true;

		for (i=0; i<10; i++) {
			if(PlayerPrefs.HasKey (i+"HScore")) {
				PlayerPrefs.DeleteKey(i+"HScore");
				PlayerPrefs.DeleteKey(i+"HScoreName");							
			}else break;
		}
		refreshScores ();
	}


	//Array mit allen Namen in Scoreboard
	public string[] GetNames() {
		init ();
		return names;
	}


	//Array mit allen Scores im Scoreboard
	public int[] getScores() {
		init ();
		return scores;
	}


	public bool getHasChanged() {
		return hasChanged;
	}

	public void setHasChanged(bool b) {
		hasChanged = b;
	}

}




